%%% SUfindSpikesFilter version 2J
% Nicola Strenzke, 22.12.2017
% This routine opens files from auditory nerve single fiber recordings from the setup in Gttingen, filters the data traces, and performs two round of spike detection: 
% First based on a manually set threshold detecting clear spikes, secondly based on the waveform of the spikes found in the first round. 
% The second round also uses a threshold from which to start comparing the trace to the waveform, this is the lower line in the images, typically half of the other threshold line (TriggerRatio=2). Higher values would increase speed.
% If no spike is detected, it takes the saved waveform from another recording of the same unit, when this is not available, a standard waveform.
% Comparison is made by root mean square deviation of all data points of the waveform.
% In a second routine, "ratespikes", the result of the spike sorting is subjectively judged for the sorting quality. 
% The variables "User", "Animals", "Units", "SpikeRatings" and "TriggerReset allow to run both routines on selected datasets. 
% To be used exclusifely on data from auditory nerve single fiber
% recordings from the setup in Gttingen judged using "SURateSpikes";
% contact NStrenzke@med.uni-goettingen.de if you want to adapt it to own
% data. 


close all
clear all
warning off MATLAB:divideByZero

%path1=['D:\SU\InAnalysis\'];
%path1=['C:\Documents and Settings\Nicola\My Documents\'];
%path1=['D:\Nicola\SU\'];
path1=['D:\Data\SU\'];
%path1=['Z:\systems\SU\InAnalysis\'];



Animal = [    
   '0013'
   '0014'
];

User='002';
Units= [1 200];
SpikeRatings=[0 1 2 3 4 5 6 7 8];  %only runs with these spike ratings are checked
%SpikeRatings=[0] ;  %only runs with these spike ratings are checked
TriggerReset=[0 1];    %[0 1] for all runs or [1] for only those runs where the trigger has been reset


%thresholdSTD=15;
maxNoiseTraces=5000; %maximal number of noise traces to display/average (affects calculation speed)
DoubleTrigger=0;    % set to 1 if you want to use twice the saved trigger height.
TriggerRatio=2;    % ratio between first triggering to get spike waveform template and second to find spikes   

thresholdRMS=0.8
filestoanalyze = []; %enter higher number first, then lower number. Caveat, it is the filenumbers in the run list, not necessarily the run number. Leave square brackets empty to analyze all.


%%% normally, no changes necessary beyond this point

ExpInfo.FreqRP2=24414;
SpikeFormRMScollected=0;
ScaleRMSHist=(-1:0.05:1);
for AnimalNo=1:size(Animal)
   path=[path1,num2str(User),'-',num2str(Animal(AnimalNo,:))]
   gui.scrsz=get(0,'ScreenSize');
   %filter=[3600 3400 3200 3000 2800 2600 2400 2200 2000 1800 1600 1400
   %1200 1000];
   %filter=[100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500];
   filter=[2500];
   filterType='low'; % high or low (pass filter)
   singlefilter=[400];
   singlefilterType='high';

   if size(dir([path,'\','ExpInfo ',path((size(path,2)-7):size(path,2)),'.mat']),1)==1
      load([path,'\','ExpInfo ',path((size(path,2)-7):size(path,2))])
   else
      Message = 'no ExpInfo-File'
   end

   for currentUnit=Units(1):Units(2);
      clear Data UnitInfo TCRunInfo TCDatSave PST SpikeTimesQuick RunList
      UnitFiles=[num2str(User),'-',num2str(Animal(AnimalNo,:)),'-',num2str(currentUnit),'-','*.mat']
      files=dir(fullfile(path,'\',UnitFiles));
      if size(files,1)==0
         Message = ['no files for Unit ',Animal(AnimalNo,:),' - ',num2str(currentUnit)]
      else
         filestoanalyze2=filestoanalyze;
         if size(filestoanalyze,2)==0 filestoanalyze2(1)=size(files,1); filestoanalyze2(2)=1; elseif size(filestoanalyze,2)==1; filestoanalyze2(2)=filestoanalyze(1);end
         for filenumber=filestoanalyze2(1):-1:filestoanalyze2(2)
            %for filenumber=5:5;
            (fullfile(path,files(filenumber).name))
            for filt=1:size(filter,2)
               clear SpikeTimesQuick AP RunInfo SpikeRating
               if isempty(findstr(fullfile(path,files(filenumber).name),'AP'))==1 %&& isempty(findstr(files(filenumber).name,'99'))==1
                  load(fullfile(path,files(filenumber).name),'RunInfo','SpikeRating')
                  message=[];
                  if exist('SpikeRating')==0;SpikeRating=0;end
                  if isfield(RunInfo,'TriggerReset')==0;RunInfo.TriggerReset=1;end
                  %SpikeRating
                  %RunInfo.TriggerReset
                  if ismember(SpikeRating,SpikeRatings)==1 &&  ismember(RunInfo.TriggerReset,TriggerReset)==1 
                     load(fullfile(path,files(filenumber).name))
                     clear AP
                     AP.thresholdRMS=thresholdRMS;
                     AP.TriggerRatio=TriggerRatio;
                     %AP.thresholdSTD=thresholdSTD;
                     %RunList(n)=cellstr(RunInfo.RunType);
                     if isfield(RunInfo,'Trigger')==0;RunInfo.Trigger=0.0003;end
                     TriggerLevel=RunInfo.Trigger;
                     if isfield(RunInfo,'invertTrace')==0 | RunInfo.invertTrace==0 RunInfo.invertTrace=-1;end
                     if exist('SpikeRating')==0;SpikeRating=0;end
                     if isfield(RunInfo,'TriggerReset')==0;RunInfo.TriggerReset=1;end
                     if DoubleTrigger==1; TriggerLevel=TriggerLevel*2;end
                     Trigger(1:size(SUDatSave,1))=TriggerLevel;


                     if isfield(RunInfo,'UseStandardWaveform')==0; RunInfo.UseStandardWaveform=0; end
                     Data1=double(SUDatSave(:,1:size(SUDatSave,2))); clear SUDatSave Trigger
                     Trigger(1:size(Data1,1))=TriggerLevel;

                     %RunInfo.RecDur=100;
                     NoiseStats(1)=mean(mean(Data1));NoiseStats(2)=mean(std(Data1));

                     %%% changed 5-29
                     %if isfield(RunInfo,'StimAmp')==0; RunInfo.StimAmp=RunInfo.Level;end
                     if strcmp(RunInfo.RunType(1:2),'RL')==1&&isfield(RunInfo,'Frequency')==0;RunInfo.Frequency=200;end;
                     if strcmp(RunInfo.RunType(1:2),'PS')==1 | strcmp(RunInfo.RunType(1:2),'FW')==1 | strcmp(RunInfo.RunType(1:2),'2k')==1; MaxStim=RunInfo.StimAmp;
                     elseif strcmp(RunInfo.RunType(1:2),'MO')==1; MaxStim=max(RunInfo.Levels1(1,:));RunInfo.StimFreq=RunInfo.Frequency;
                     elseif strcmp(RunInfo.RunType(1:2),'RL')==1; MaxStim=max(RunInfo.Levels(1,:));RunInfo.StimFreq=RunInfo.Frequency;
                     else MaxStim=0;
                     end
                     for n=1:size(Data1,2)  %%% filter
                        %tic
                        [b,a]=butter(2, singlefilter/(ExpInfo.FreqRP2/2) ,singlefilterType);
                        Data(:,n)=filtfilt(b,a,Data1(:,n));
                        [b,a]=butter(2, filter(filt)/(ExpInfo.FreqRP2/2) ,filterType);
                        Data(:,n)=filtfilt(b,a,Data(:,n));
                        RunInfo.Filters=[singlefilter filter(filt) 0];
                        %if (strcmp(RunInfo.RunType(1:2),'PS')==1 | strcmp(RunInfo.RunType(1:2),'RL')==1)
                        %%% for high levels of frequencies below 12kHz filter out stimulus artifact
                        if isfield (RunInfo,'Stimulus')==1
                        if strcmp(RunInfo.RunType(1:2),'RE')==1 & n<size(Data1,2)-1
                           if isfield (RunInfo,'StimAmp')==1;RunInfo.StimFreq=RunInfo.Frequency(n);MaxStim=RunInfo.StimAmp(n);else RunInfo.StimFreq=100;MaxStim=90; end
                        end
                        if strcmp(RunInfo.RunType(1:2),'TC')==1;
                           MaxStim=RunInfo.TCDatSave(2,n); RunInfo.StimFreq=RunInfo.TCDatSave(1,n);
                        end
                        if  strcmp(RunInfo.Stimulus(1:3),'Sin')==1 & MaxStim>80 & RunInfo.StimFreq<=10000
                           if RunInfo.StimFreq<160
                              [b,a]=butter(2, [(RunInfo.StimFreq-90)/(ExpInfo.FreqRP2/2) (RunInfo.StimFreq+90)/(ExpInfo.FreqRP2/2)] ,'stop');
                           else
                              [b,a]=butter(2, [(RunInfo.StimFreq-150)/(ExpInfo.FreqRP2/2) (RunInfo.StimFreq+150)/(ExpInfo.FreqRP2/2)] ,'stop');
                           end
                           Data(:,n)=filtfilt(b,a,Data(:,n));
                           RunInfo.Filters(3)=RunInfo.StimFreq;
                        end
                        end
                        %toc
                     end
                     %%% end changed 5-29

                     %if strcmp (RunInfo.RunType,'TC')==1
                     clear SpikeTimesQuick
                     for n=1:size(Data,2)
                        [Spike]=SUFindSpikeQuick2(Data(:,n),TriggerLevel);
                        Spike=Spike'/ExpInfo.FreqRP2*1000;%make SpikeTimesQuick contain data in ms format in columns
                        SpikeTimesQuick(1:size(Spike,1),n)=Spike; clear Spike
                     end
                     %end
                     SpikeTimesQuick=SpikeTimesQuick*ExpInfo.FreqRP2/1000;


                     Data1=Data; n=0;
                     for r=size(SpikeTimesQuick,1):-1:1 %pass upwards through rows (last spike to first spike in each repeat)
                        for c=1:size(SpikeTimesQuick,2) % pass through columns (repeats)
                           if SpikeTimesQuick(r,c)>0 & (SpikeTimesQuick(r,c)<(size(Data,1)-20)) & (SpikeTimesQuick(r,c) >= 60)
                              %if RunInfo.invertTrace==1 SpikeTimesQuick(r,c)=SpikeTimesQuick(r,c)-10; end
                              n=n+1;uin=round(SpikeTimesQuick(r,c));
                              SpikeForm(:,n)=Data(uin-9:(uin+20),c);  %% collect Spike forms according to SpikeTimesQuick

                              SpikeForm(:,n)=SpikeForm(:,n)-mean(SpikeForm(:,n));
                              SpikePre(:,n)=Data(uin-50:(uin-11),c);
                              SpikePre(:,n)=SpikePre(:,n)-mean(SpikePre(:,n));
                           end
                        end
                        if n>1000
                           break
                        end
                     end
                     clear uin
                     if n>=2 & RunInfo.UseStandardWaveform==0
                        SpikeFormStats(1,:)=nanmean(SpikeForm');SpikeFormStats(2,:)=std(SpikeForm');
                        SpikePreStats(1,:)=nanmean(SpikePre');SpikePreStats(2,:)=std(SpikePre');
                        NoiseStats(1)=nanmean(SpikePreStats(1,:));NoiseStats(2)=std(SpikePreStats(1,:));
                     elseif n<=2 | RunInfo.UseStandardWaveform==1
                        if exist(fullfile(path,[num2str(User),'-',num2str(Animal(AnimalNo,:)),'-',num2str(currentUnit),'-APwaveform.mat']))==2
                           load(fullfile(path,[num2str(User),'-',num2str(Animal(AnimalNo,:)),'-',num2str(currentUnit),'-APwaveform.mat']))
                           %SpikeForm(1:30,1)=waveform';SpikePre(1:30,1)=0;SpikePreStats(1:2,1:30)=0;SpikeFormStats(1:2,1:30)=0;
                           SpikeForm(1:30,1)=waveform';SpikeFormStats(1,1:30)=waveform;SpikePre(1:30,1)=0;SpikePreStats(1:2,1:30)=0;SpikeFormStats(2,1:30)=0;
                           message='standard waveform used'
                        else
                           load ([path1,'avWaveForm'],'APwaveform');
                           SpikeForm(1:30,1)=APwaveform(1,21:50)';SpikePre(1:30,1)=0;SpikePreStats(1:2,1:30)=0;SpikeFormStats(1:2,1:30)=0;
                           n=max(Data(:,:)); m=max(n);
                           if m<NoiseStats(1)+(NoiseStats(2)*4)|isfield(RunInfo,'cropped')==1;  m=4e-4; end
                           SpikeFormStats(1:2,1:30)=APwaveform(1:2,21:50)*m;
                           message='standard waveform used'
                        end
                     end

                     Figure=figure('name',fullfile(path,files(filenumber).name),'Position',[gui.scrsz(3)/2  gui.scrsz(4)/2.5 gui.scrsz(3)/2 gui.scrsz(4)/2]);% Position [left bottom width height]
                     subplot(2,2,1);plot(SpikePre,'-');hold on;plot(SpikePreStats(1,:),'x-k','LineWidth',2);plot(10,TriggerLevel,'r.','MarkerSize',20);plot(SpikePreStats(1,:)+(1*SpikePreStats(2,:)),'kx');plot(SpikePreStats(1,:)-(1*SpikePreStats(2,:)),'xk');title('original noise pre-spike');hold off;
                     subplot(2,2,3);plot(SpikeForm,'-');hold on;plot(SpikeFormStats(1,:),'x-k','LineWidth',2);plot(10,TriggerLevel,'r.','MarkerSize',20);plot(SpikeFormStats(1,:)+(1*SpikeFormStats(2,:)),'xk');;plot(SpikeFormStats(1,:)-(1*SpikeFormStats(2,:)),'xk');title(['first template n=',num2str(size(SpikeForm,2))]);hold off;

                     for c=1:size(SpikeForm,2) %calculate RMS, normalize to be 0 for average spike and 1 for average prespike
                        for r=1:size(SpikeForm,1)
                           SpikePreRMS1(r,c)  =(SpikeFormStats(1,r)'-SpikePre(r,c))^2;
                           SpikeFormRMS1(r,c)=(SpikeFormStats(1,r)'-SpikeForm(r,c))^2;
                        end
                     end
                     SpikePreRMS2=(sqrt(sum(SpikePreRMS1)/30));
                     SpikeFormRMS2=(sqrt(sum(SpikeFormRMS1)/30));
                     meanSpikeFormRMS2=nanmean(SpikeFormRMS2);
                     meanSpikePreRMS2=nanmean(SpikePreRMS2)-meanSpikeFormRMS2;
                     SpikePreRMS=(SpikePreRMS2-meanSpikeFormRMS2)/meanSpikePreRMS2;
                     SpikeFormRMS=(SpikeFormRMS2-meanSpikeFormRMS2)/meanSpikePreRMS2;
                     m=0;
                     for n=1:size(SpikeForm,2)  %%% find candidates for 'good' SpikeForm2: SpikeForm2 acceptable (RMS>0.66) and amplitude at expected maximum at least TriggerLevel
                        if SpikeFormRMS(n)<AP.thresholdRMS %& SpikeForm(10,n)>TriggerLevel %((RunInfo.invertTrace==-1 & SpikeForm(10,n)>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2))  | (RunInfo.invertTrace==1 &(SpikeForm(20,n))>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2)))
                           %if SpikeFormRMS(n)<AP.thresholdRMS & SpikeForm(10,n)>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2) %((RunInfo.invertTrace==-1 & SpikeForm(10,n)>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2))  | (RunInfo.invertTrace==1 &(SpikeForm(20,n))>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2)))
                           %if SpikeFormRMS(n)<AP.thresholdRMS & ((RunInfo.invertTrace==-1 & SpikeForm(10,n)>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2))  | (RunInfo.invertTrace==1 &(SpikeForm(20,n))>NoiseStats(1)+AP.thresholdSTD*NoiseStats(2)))
                           m=m+1;
                           SpikeForm2(:,m)=SpikeForm(:,n);
                           SpikePre2(:,m)=SpikePre(:,n);
                           plot(SpikeForm(:,n));
                        else
                           test=1;
                        end
                     end

                     if m>=2
                        SpikeFormStats2(1,:)=nanmean(SpikeForm2');SpikeFormStats2(2,:)=std(SpikeForm2');
                        SpikePreStats2(1,:)=nanmean(SpikePre2');SpikePreStats2(2,:)=std(SpikePre2');
                        %NoiseStats(1)=mean(SpikePreStats2(1,:));NoiseStats(2)=std(SpikePreStats2(1,:));
                     elseif m<=1
                        SpikeFormStats2(1,:)=SpikeFormStats(1,:);SpikeFormStats2(2,:)=SpikeFormStats(2,:);
                        SpikePreStats2(1,:)=SpikePreStats(1,:);SpikePreStats2(2,:)=SpikePreStats(2,:);
                        if m==0    SpikeForm2=0;SpikePre2=0; end;
                     end

                     NoiseStats2(1)=nanmean(SpikePreStats2(1,:));
                     NoiseStats2(2)=std(SpikePreStats2(1,:));
                     subplot(2,2,2);plot(SpikePre2);hold on;plot(SpikePreStats2(1,:),'x-k','LineWidth',2);plot(10,TriggerLevel,'r.','MarkerSize',20);plot(SpikePreStats2(1,:)+(1*SpikePreStats2(2,:)),'xk');;plot(SpikePreStats2(1,:)-(1*SpikePreStats2(2,:)),'xk');title('matched');hold off;
                     subplot(2,2,4);plot(SpikeForm2);hold on;plot(SpikeFormStats2(1,:),'x-k','LineWidth',2);plot(10,TriggerLevel,'r.','MarkerSize',20);plot(SpikeFormStats2(1,:)+(1*SpikeFormStats2(2,:)),'xk');;plot(SpikeFormStats2(1,:)-(1*SpikeFormStats2(2,:)),'xk');title(['second template n=',num2str(size(SpikeForm2,2))]);hold off;
                     clear SpikeForm SpikeFormRMS SpikeFormRMS1 SpikeFormRMS2 SpikePreRMS SpikePreRMS1 SpikePreRMS2 SpikeFormStats SpikePre
                     TriggerLevel=TriggerLevel/TriggerRatio;
                     %TriggerLevel=NoiseStats2(1)+AP.thresholdSTD*NoiseStats2(2);
                     y=0;z=0;                close all

                     for c=1:size(Data,2) % browse repeats
                        x=0;
                        Spike=[];[Spike]=SUFindSpikeQuick2(Data(:,c),TriggerLevel);
                        for n=1:size(Spike,2) %browse Spikes per repeat
                           %if RunInfo.invertTrace==1 Spike(n)=Spike(n)-10; end
                           if Spike(n)>=10 & Spike(n)<size(Data,1)-20
                              SpikeForm=Data(Spike(n)-9:(Spike(n)+20),c);%collect current SpikeForm
                              SpikeForm1=SpikeForm-(nanmean(SpikeForm)); %normalize to  be arranged around 0
                              for m=1:30
                                 SpikeFormRMS1(m)=(SpikeFormStats2(1,m)'-SpikeForm1(m))^2;
                                 SpikeFormRMS1forSNR(m)=SpikeForm1(m)^2;
                                 SpikePreRMS1(m)       =SpikeForm1(m)^2;
                              end
                              SpikePreRMS2=(sqrt(sum(SpikePreRMS1)/30));
                              SpikeFormRMS2=(sqrt(sum(SpikeFormRMS1)/30)); % RMS for individual spike
                              SpikeFormRMS2forSNR=(sqrt(sum(SpikeFormRMS1forSNR)/30));

                              %for c=1:size(Data,2) %mean RMS for each trace corrected to be 0 for average Spike Form from previous sorting and 1 for average Noise Form
                              SpikePreRMS=(SpikePreRMS2-meanSpikeFormRMS2)/meanSpikePreRMS2; %
                              SpikeFormRMS=(SpikeFormRMS2-meanSpikeFormRMS2)/meanSpikePreRMS2;
                              %end
                              SpikeFormRMScollected(size(SpikeFormRMScollected,2)+1)=SpikeFormRMS;
                              clear prelSpikeRMS SpikeFormRMS1
                              %if SpikeFormRMS2 < 1-(5*std(SpikePreRMS)) & SpikeForm1(10)>TriggerLevel; %if RMS is smaller than 1-(2*std) and normalized Spike Form is still above Trigger

                              if ((SpikeFormRMS < AP.thresholdRMS) & SpikeFormRMS> (AP.thresholdRMS*-1)) & SpikeForm1(10)>TriggerLevel %((RunInfo.invertTrace==-1 & SpikeForm1(10)>TriggerLevel) | (RunInfo.invertTrace==1 & SpikeForm1(20)>TriggerLevel)); %if RMS is smaller than 1-(2*std) and normalized Spike Form is still above Trigger
                                 %if SpikeFormRMS < AP.thresholdRMS & SpikeForm1(10)>TriggerLevel %((RunInfo.invertTrace==-1 & SpikeForm1(10)>TriggerLevel) | (RunInfo.invertTrace==1 & SpikeForm1(20)>TriggerLevel)); %if RMS is smaller than 1-(2*std) and normalized Spike Form is still above Trigger
                                 x=x+1;y=y+1;
                                 [AP.SpikeAmpPos(x,c),Posi(1)]=(max(SpikeForm1));
                                 [AP.SpikeAmpNeg(x,c),Posi(2)]=(min(SpikeForm1));
                                 %AP.SpikeAmp(x,c)=(AP.SpikeAmpPos(x)-AP.SpikeAmpNeg(x));
                                 SpikeRMS(y)=SpikeFormRMS2;
                                 SpikeRMSforSNR(y)=SpikeFormRMS2forSNR;
                                 if AP.SpikeAmpPos(x,c)>=AP.SpikeAmpNeg(x,c) AP.SpikeTimes(x,c)=(Spike(n)+(Posi(1))); else AP.SpikeTimes(x,c)=(Spike(n)+(Posi(2))); end
                                 SpikeWaveforms(:,y)=(SpikeForm1);
                                 if Spike(n)>30 & Spike(n)<size(Data,1)-60    SpikeFormFinal(:,y)=Data(Spike(n)-29:(Spike(n)+60),c)-nanmean(Data(Spike(n)-29:(Spike(n)+60),c)); else SpikeFormFinal(1:90,y)=NaN; end
                                 %if Spike(n)>30 & Spike(n)<size(Data,1)-60    SpikeFormFinal(1:30,y)=SpikeForm1; end
                                 %if Spike(n)>50
                                 %    Noise(:,y)=(Data(Spike(n)-50:(Spike(n)-11),c));
                                 %    for m=1:30 NoiseRMS1(m)=AP.Noise(m)^2; end
                                 %    AP.NoiseRMS(y)=sqrt(mean(NoiseRMS1)/30);
                                 %end
                                 if Spike(n)>30 & Spike(n)<size(Data,1)-50
                                    % if RunInfo.invertTrace==-1 Data1(Spike(n)-29:Spike(n)+40,c)=NaN; else Data1(Spike(n)-19:Spike(n)+50,c)=NaN; end
                                    Data1(Spike(n)-30:Spike(n)+50,c)=NaN;
                                 else Data1(Spike(n)-9:Spike(n)+19,c)=NaN;
                                 end
                              else
                                 if z<maxNoiseTraces
                                    z=z+1;NoSpikeWaveforms(:,z)=(SpikeForm1);
                                 end
                              end
                           end
                        end
                        for r=1:size(Data,1)
                           DataRMS(r,c)=Data1(r,c)^2;
                        end
                     end
                     AP.NoiseRMS=sqrt(nanmean(nanmean(DataRMS)));
                     AP.filterFreq=filter(filt);
                     AP.filterType=filterType;
                     OutputFigure=figure('name',fullfile(path,files(filenumber).name),'Position',[50 50 gui.scrsz(3)*0.5 gui.scrsz(4)/2]);
                     if z>=1  subplot(2,3,3);plot(NoSpikeWaveforms);hold on;plot(10,TriggerLevel,'b.','MarkerSize',15);title(['sorted out n=',num2str(size(NoSpikeWaveforms,2)),' ',num2str(filter(filt))]);hold off;end
                     if y>=1
                        if size(SpikeFormFinal,2)>=2 AP.avWaveForm(1,:)=nanmean(SpikeFormFinal'); AP.avWaveForm(2,:)=std(SpikeFormFinal');else AP.avWaveForm(1:2,1:90)=0; end
                        AP.SNR=mean(SpikeRMSforSNR)/AP.NoiseRMS;
                        %subplot(2,3,6);plot(SpikeFormFinal);hold on;plot(40,TriggerLevel,'b.','MarkerSize',15);title(['final n=',num2str(size(SpikeWaveforms,2)),', SNR ',num2str(AP.SNR)]);plot(AP.avWaveForm(1,:),'x-k','LineWidth',2);hold off
                        %subplot(2,3,2);plot(Noise);hold on;plot(0,TriggerLevel,'b.','MarkerSize',15);title('final noise pre-spike');hold off;
                        SpikeFormFinal=double(SpikeFormFinal);
                        Output(1,filt)=filter(filt);
                        Output(2,filt)=mean(SpikeRMS);
                        Output(3,filt)=AP.NoiseRMS;
                        Output(4,filt)=AP.SNR;
                        Output(5:34,filt)=AP.avWaveForm(1,30:59)';
                        subplot(2,2,1);plot(Data);hold on; plot(Trigger,'LineWidth',2);plot(Trigger/TriggerRatio);axis tight;hold off; ylabel([fullfile(path,files(filenumber).name)]);hold off;title(['Filter ',num2str(filter(filt)),'  ',num2str(singlefilter)]);
                        randomperm=randperm(size(SpikeFormFinal,2));
                        subplot(2,2,3)
                        if (size(SpikeFormFinal,2))<=1000
                           plot(SpikeFormFinal);hold on; plot(AP.avWaveForm(1,:),'x-k','LineWidth',2);
                        else
                           for bb=1:1000
                              SpikeFormFinalSelected(1:90,bb)=SpikeFormFinal(1:90,randomperm(bb)); % line of average is black when all individual traces are shown.
                           end
                           plot (SpikeFormFinalSelected);hold on;plot(AP.avWaveForm(1,:),'x-b','LineWidth',2); % line of average is blue when plot is restricted to 1000 randomly chosen traces
                        end
                        plot(30,TriggerLevel,'k.','MarkerSize',18);title(['n=',num2str(size(SpikeWaveforms,2)),', SNR ',num2str(AP.SNR,'%3.1f')]);axis([1 90 -inf inf]);hold off
                        waveform=AP.avWaveForm(1,20:49);
                        if strcmp(message,'standard waveform used')==0; save(fullfile(path,[num2str(User),'-',num2str(Animal(AnimalNo,:)),'-',num2str(currentUnit),'-APwaveform']),'waveform');end
                        if z>=1  subplot(2,2,4);plot(NoSpikeWaveforms);hold on;plot(10,TriggerLevel,'k.','MarkerSize',18);title(['sorted out n=',num2str(size(NoSpikeWaveforms,2))]);plot(SpikeFormStats2(1,:)','x-k','LineWidth',2);axis([1 30 -inf inf]);hold off;end
                        subplot(2,2,2);plot(Data1(:,1:size(Data1,2)));axis tight; SpikeFormFinal=single(SpikeFormFinal);title(['RMSthreshold' ,num2str(thresholdRMS),' TriggerRatio ',num2str(TriggerRatio)]);
                     else subplot(1,2,1); plot(Data);hold on; plot(Trigger,'LineWidth',2); plot(Trigger/TriggerRatio);ylabel([fullfile(path,files(filenumber).name)]);title(['Filter ',num2str(filter(filt)),'  ',num2str(singlefilter)]);hold off;subplot(1,2,2);plot(Data1(:,1:size(Data1,2)));title(['RMSthreshold ',num2str(thresholdRMS),' TriggerRatio ',num2str(TriggerRatio)]);
                     end
                     RunInfo.TriggerReset=0;
                     
                     RunInfo.changeRating=1;
                     RunInfo.SpikeRMShist=hist(SpikeFormRMScollected,ScaleRMSHist);
                     %figure
                     %plot(ScaleRMSHist,RunInfo.SpikeRMShist)
                     save(fullfile(path,files(filenumber).name),'AP','RunInfo','-APPEND')
                     fullfile(path,files(filenumber).name)
                     print ('-djpeg','-r150',[fullfile(path,files(filenumber).name),'.jpg']);
                     clear AP Data Data1 SpikeTimesQuick RunInfo SpikeAmp NoiseStats Output Spike SpikeFormRMS SpikePreRMS1 SpikeRating a b meanSpikeFormRMS2 meanSpikePreRMS2 SpikeFormFinal Noise waveform SpikeTimes SpikeWaveforms NoSpikeWaveforms SpikeFormRMS1 SpikeFormRMS2 TriggerLevel SpikeFormStats2 SpikeForm1 SpikeForm2 SpikePreStats2 NoiseStats2 DataRMS SNR AP Posi TData NoiseRMS1 Noise SpikeForm SpikePre SpikePre2 SpikePreRMS SpikePreRMS2 SpikePreStats SpikePreStats2 SpikeRMS StimulusSave c m n r x y z
                  end
                  clear SpikeTimesQuick RunInfo Data Data1
                  close gcf
               end
            end
         end
      end
   end
end

isNotEnde=0;
sound( sin( 660*(2*pi*(0:(0.5*22050))/22050) ), 22050)
close gcf
